#!/usr/bin/perl
#
$Version = 0.01;
@ARGV = (	"../phrases/phrases_en.xml",
			"../../release",
			"../templates/templates.xml");

#
# Extracts the phrases from $argv[0] and cross-references against phrases in all other arguments
#
# Usage : phraseval.pl
#

use strict;
use Cwd 'abs_path';
use Win32;

my $XML;
my $FILE;
my $phraselist = "";

my $xml = shift @ARGV;
open $XML , "<", $xml or die "Unable to open $xml";
while (<$XML>) { $phraselist .= $_; }
close $XML;

my %set_phrases = ();
while ($phraselist =~ m/<phrase name="(.*?)"/gs) {
    $set_phrases{$1} = 0;
}

# Find all the .php/.xml/.module files in the directory tree under the argument directory
sub findcodefiles {

	my $path = shift(@_);
	my $root = abs_path($path);
	my @filelist = ();
	my $DIR;

	opendir($DIR, $root) || die "can't opendir $root: $!";
	my @files = readdir($DIR);
	closedir $DIR;

FILE:
	foreach my $file (@files) {
		if ($file =~ m{^\.+$}) {
			next FILE;
		}
		my $fullfile = $root.'/'.$file;
		if (-d $fullfile) {
			push @filelist, findcodefiles($fullfile);
		}
		elsif ($fullfile=~/\.php$/) {
			push @filelist, $fullfile;
		}
		elsif ($fullfile=~/\.xml$/) {
			push @filelist, $fullfile;
		}
		elsif ($fullfile=~/\.module$/) {
			push @filelist, $fullfile;
		}
	}

	return @filelist;

}

my @files = findcodefiles(shift @ARGV);

while (my $file = shift @ARGV) {
	push @files, $file;
}

while (my $file = shift @files) {
	my $clean = 1;
    open $FILE , "<", $file or die "Unable to open $file";
    $phraselist = "";
    while (<$FILE>) { $phraselist .= $_; }
    close $FILE;
    $phraselist =~ s/\$vbphrase\['[^']*'[\w\.]+\$[^\[]*\[[^\]]*\]\]//gs; # eliminate concatenations
    while ($phraselist =~ m/(\$vbphrase\[['"]*(.*?)['"]*\])/gs) {
        if (exists $set_phrases{$2}) {
            $set_phrases{$2}++;
        }
        else {
			if ($clean) {
			    print Win32::GetLongPathName($file)."\n";
			    $clean = 0;
			}
            print "Unrecognised: \$vbphrase[".$2."]\n";
        }
    }
    if (!$clean) {
    	print "\n";
    }
}

print "\n\n";
foreach my $k (sort keys %set_phrases) {
    printf "%3d %s\n" , $set_phrases{$k}, $k;
}

